from qmdl.mdl import Mdl
from qmdl.palette import palette
from collections import defaultdict
import math

mymdl = Mdl()
infile = open(r"console.mdl", "rb")
mymdl.read(infile)
infile.close()

#import the "bumpmap" as a skin
from PIL import Image, ImagePalette
im=Image.open("bumpmap.pcx")
sk=Mdl.Skin(mymdl.skinwidth ,mymdl.skinheight)
sk.pixels=im.tostring()
mymdl.skins.append(sk)

#build a dictionary from pixel colours to a list of vertices with that colour
cols=defaultdict(list)
for i in range(len(mymdl.vertices)):
    vt = mymdl.vertices[i]
    col = mymdl.skins[1].pixel(vt.u, vt.v)
    cols[col].append(i)


#loop through the frames applying effects to vertices of a colour
for i in range(16):
    fr = mymdl.frames[i]
    fr.name = ("alert" + str(i + 1)).encode("ascii")
    for vertex in fr.vertices:
        # deflect all of the vertex normals down so they are darker
        # and so the light effects stand out
        norm = vertex.decode()
        deflect = (norm[0], norm[1], norm[2]-0.5)
        vertex.encode(deflect)
    for vi in cols[208]:
        #upper surfaces around the siren
        org = mymdl.translate(fr.vertices[vi])
        theta = math.atan(org[1] / org[0])
        theta += i * math.pi / 4
        fr.vertices[vi].encode((math.cos(theta), math.sin(theta), 0))
    for vi in cols[176]:
        #radar circumference
        org = mymdl.translate(fr.vertices[vi])
        org = tuple(a - b for a, b in zip(org, (35.7, -0.25, 40.22)))
        theta = (i - 5) * math.pi / 7.5
        norm = (0.3 * (math.cos(theta) * org[1] - math.sin(theta) * org[2]),
                math.cos(theta) * org[2] + math.sin(theta) * org[1],
                0.2 - 0.03 * i * i)
        fr.vertices[vi].encode(norm)
    for vi in cols[160]:
        #radar centre
        fr.vertices[vi].encode((0, 20, 7 - i))

        
#group the frames
fg = Mdl.FrameGroup()
fg.sequencemin = mymdl.frames[0].bbox_min
fg.sequencemax = mymdl.frames[0].bbox_max
fg.duration = [(1 + x) / 10 for x in range(16)]
fg.frames = mymdl.frames
mymdl.frames = [fg]

#delete the bumpmap skin again
del mymdl.skins[1]

outfile = open(r"console.mdl", "wb")
mymdl.write(outfile)
outfile.close()
