from qmdl.helper import Helper

#read the model file
mymdl = Helper()
mymdl.load("water.mdl")

#apply new sequencial names to the frames
mymdl.rename_frames([("flow", len(mymdl.mdl.frames))])

for frame in mymdl.mdl.frames:
    for vertex in frame.vertices:
        vertex.encode((0, 0, 1))
mymdl.group_frames(0, len(mymdl.mdl.frames)-1, "flow")
#import these skinfiles
skinlist = []
for skin in skinlist:
    mymdl.append_skin(skin)

mymdl.mdl.scale = tuple ([i*4 for i in mymdl.mdl.scale])
mymdl.mdl.origin = (mymdl.mdl.scale[0]*4,
                    mymdl.mdl.scale[1]*4,
                    mymdl.mdl.scale[2]*4 - 512)
mymdl.save()
