/**
 * qml.h
 **/
#ifndef	_QML_H		
#define	_QML_H				1
#define	QML_VERSION			"1.0"

// data types
#define	DT_NONE				0
#define	DT_BOOL				1
#define	DT_BYTE				2	// 0 to 255
#define	DT_ANGLE			4	// 0 to 359
#define	DT_INT				8
#define	DT_FLOAT			16	// always between 0.0 and 1.0 inclusive
#define	DT_PERCENTUAL		32	// always between 0% and 100% inclusive
#define	DT_STRING			64

#define	DT_VAR				0x8000

typedef enum {
	ttNone,
	ttCtrl,
	ttTag,
	ttAttr,
	ttVar,
	ttVarArray,
	ttScalar,
	ttOperator}tokenType_t;

typedef enum {
	qtNone,
	qtText,
	qtPic,
	qtBsp,
	qtMdl,
	qtSpr,
	qtIf,
	qtEndif,
	qtBar,
	qtSnd}qmlTag_t;

typedef enum {
	qaNone,
	qaX,
	qaY,
	qaSrc,
	qaValue,
	qaFrame,
	qaSkin,
	qaColorMap,
	qaScale,
	qaRoll,
	qaTilt,
	qaYaw,
	qaWidth,
	qaHeight,
	qaRed,
	qaGreen,
	qaBlue,
	qaAlpha,
	qaVolume,
	qaLoop} qmlAttr_t;
#define		QMLMAX_ATTR			17


typedef enum {
	qvNone,
	qvHealth,
	qvFrags,
	qvCurrentWeapon,
	qvCurrentAmmo,
	qvArmorValue,
	qvArmorType,
	qvAmmoArray,
	qvKilledMonsters,
	qvTotalMonsters,
	qvSecretsFound,
	qvTotalSecrets,
	qvTimeDD,
	qvTimeHH,
	qvTimeMM,
	qvTimeSS,
	qvAbsoluteTime,			// in seconds
	qvMapName,
	qvBspName,
	qvGameDir,
	qvModName,				// in engines that support it, 
							// the mod title (ex: "Scourge of Armaggon"), 
							// otherwise repeats the gamedir value
	qvEngine,
	qvCoop,
	qvDeathmatch,
	qvMaxPlayers,
	qvNumPlayers,
	qvWorldType,
	qvWeaponArray,
	qvKeyArray,
	qvRuneArray,
	qvPowerupArray,
	qvClientNameArray,
	qvClientScoreArray,
	qvClientPingArray,
	qvFunctionArray,
	qvEventArray} qmlVar_t;

typedef enum {
	qOpNone,
	qOpEq,
	qOpNotEq,
	qOpGt,
	qOpGtEq,
	qOpLt,
	qOpLtEq}qmlOp_t;

typedef enum {
	qCtlNone,
	qCtlQMLBegin,
	qCtlQMLEnd,
	qCtlTagBegin,
	qCtlTagEnd,
	qCtlVarBegin,
	qCtlVarEnd,
	qCtlValBegin}qCtrl_t;

// tokens
// control values
#define	TK_QMLBEGIN			"<qml"
#define	TK_QMLEND			"</qml>"
#define	TK_BEGINTAG			"<%"
#define	TK_ENDTAG			"/>"
#define	TK_BEGINVAR			"${"
#define	TK_ENDVAR			"}"
#define	TK_BEGINVALUE		"="
// tags
#define	TK_TXT				"txt"
#define	TK_PIC				"pic"
#define	TK_BSP				"bsp"
#define	TK_MDL				"mdl"
#define	TK_SPR				"spr"
#define	TK_IF				"if"
#define	TK_ENDIF			"endif"
#define	TK_BAR				"bar"
#define	TK_SND				"snd"
// attrs
#define	TK_X				"x"
#define	TK_YAW				"yaw"
#define	TK_Y				"y"
#define	TK_SRC				"src"
#define	TK_VALUE			"value"
#define	TK_SCALE			"scale"
#define	TK_FRAME			"frame"
#define	TK_SKIN				"skin"
#define	TK_COLORMAP			"colormap"
#define	TK_ROLL				"roll"
#define	TK_TILT				"tilt"
#define	TK_WIDTH			"width"
#define	TK_HEIGHT			"height"
#define	TK_RED				"red"
#define	TK_GREEN			"green"
#define	TK_BLUE				"blue"
#define	TK_ALPHA			"alpha"
#define	TK_VOLUME			"volume"
#define	TK_LOOP				"loop"
// environment vars
#define	TK_HEALTH			"health"
#define	TK_FRAGS			"frags"
#define	TK_CURRWEP			"currwep"
#define	TK_CURRAMMO			"currammo"
#define	TK_ARMORVALUE		"armorvalue"
#define	TK_ARMORTYPE		"armortype"
#define	TK_AMMOARRAY		"ammo"
#define	TK_KILLEDMONSTERS	"killedmonsters"
#define	TK_TOTALMONSTERS	"totalmonsters"
#define	TK_SECRETSFOUND		"secretsfound"
#define	TK_TOTALSECRETS		"totalsecrets"
#define	TK_TIMEDD			"timedd"
#define	TK_TIMEHH			"timehh"
#define	TK_TIMEDD			"timedd"
#define	TK_TIMEMM			"timemm"
#define	TK_TIMESS			"timess"
#define	TK_ABSTIME			"abstime"
#define	TK_MAPNAME			"mapname"
#define	TK_BSPNAME			"bspname"
#define	TK_GAMEDIR			"gamedir"
#define	TK_MODNAME			"modname"
#define	TK_ENGINE			"engine"
#define	TK_COOP				"coop"
#define	TK_DEATHMATCH		"dm"
#define	TK_MAXPLAYERS		"maxplayers"
#define	TK_NUMPLAYERS		"numplayers"
#define	TK_WORLDTYPE		"worldtype"
#define	TK_WEPARRAY			"weapon"
#define	TK_KEYARRAY			"key"
#define	TK_RUNEARRAY		"rune"
#define	TK_POWERUPARRAY		"powerup"
#define	TK_NAMEARRAY		"name"
#define	TK_SCOREARRAY		"score"
#define	TK_PINGARRAY		"ping"
#define	TK_FUNCARRAY		"function"
#define	TK_EVENTARRAY		"event"			// every time an event is triggered,
											// the corresponding value in the array
											// resets to 0, and is incremented at
											// 10Hz rate up to 255
// operators
#define	TK_EQUALS			"=="
#define	TK_NOTEQUALS		"!="
#define	TK_GREATER			">"
#define	TK_GREATEROREQUAL	">="
#define	TK_LESSER			"<"
#define	TK_LESSEROREQUAL	"<="

// =============================================================================
typedef struct	{
	char			*token;
	tokenType_t		type;
	union	V	{
		qmlTag_t	tag;
		qmlAttr_t	attr;
		qmlVar_t	var;
		qmlOp_t		op;
		qCtrl_t		ctrl;
	}v;
	int				supported;	// valid data types (for attr)
}qmlParse_t;

typedef struct	{
	int				type;
	int				i;
	float			f;
	char			*s;
	qmlVar_t		var;
	int				index;		// for array-type vars
}qmlValue_t;

typedef struct	{
	qmlAttr_t		attr;
	qmlValue_t		value;
}qmlPair_t;

typedef struct	{
	qmlValue_t		value1;		// only executed if
	qmlOp_t			op;			// value1 op value 
	qmlValue_t		value2;		// evaluates as true
	int				jump;		// jumps to this if false
	qmlTag_t		tag;
	qmlPair_t		*pairs;
}qmlElement_t;

typedef struct	{
	qmlElement_t	*elements;
	int				numElements;
}qml_t;

// =============================================================================

qml_t	*qmlLoad (char *text);
void	qmlPrecache (qml_t *qml);
void	qmlRender (qml_t *qml);
#endif
