/**
 * qml_render.c
 **/
#include <stdlib.h>
#include <string.h>

#include "qml.h"

int		qmlGetInt (qmlValue_t *value)
{
	int		result = 0;

	if (value->type & (DT_BOOL|DT_BYTE|DT_ANGLE|DT_INT))
	{
		result = value->i;
	}
	// TODO: DT_VAR support

	return (result);
}

float	qmlGetFloat (qmlValue_t *value)
{
	float	result = 0.0f;

	if (value->type & (DT_PERCENTUAL|DT_FLOAT))
	{
		result = value->f;
	}
	// TODO: DT_VAR support

	return (result);
}

char	*qmlGetString (qmlValue_t *value)
{
	char	*result = NULL;

	if (value->s)
	{
		result = _strdup(value->s);
	}
	// TODO: DT_VAR support

	return (result);
}

void	qmlDrawText (qmlPair_t *attrs)
{
	// TODO: implement
}

void	qmlDrawPic (qmlPair_t *attrs)
{
	// TODO: implement
}

void	qmlDrawMdl (qmlPair_t *attrs)
{
	// TODO: implement
}

void	qmlDrawSpr (qmlPair_t *attrs)
{
	// TODO: implement
}

void	qmlDrawBsp (qmlPair_t *attrs)
{
	// TODO: implement
}

void	qmlDrawBar (qmlPair_t *attrs)
{
	// TODO: implement
}

void	qmlPlaySound (qmlPair_t *attrs)
{
	// TODO: implement
}

int		qmlEvaluate (qmlElement_t *element)
{
	int		i;

	if (element)
	{
		if (element->jump != -1)
		{
			i = element->value1.type & element->value2.type;
			switch (element->op)
			{				
				case	qOpEq:
					if (i & (DT_BOOL|DT_BYTE|DT_ANGLE|DT_INT))
					{
						return (qmlGetInt (&element->value1) == qmlGetInt (&element->value2));
					}
					else if (i & (DT_PERCENTUAL|DT_FLOAT))
					{
						return (qmlGetFloat (&element->value1) == qmlGetFloat (&element->value2));
					}
					else if (i & DT_STRING)
					{
						return (!strcmp (qmlGetString(&element->value1), qmlGetString(&element->value2)));
					}
					else
					{
						return (0);
					}
				break;
				case	qOpNotEq:
					if (i & (DT_BOOL|DT_BYTE|DT_ANGLE|DT_INT))
					{
						return (qmlGetInt (&element->value1) != qmlGetInt (&element->value2));
					}
					else if (i & (DT_PERCENTUAL|DT_FLOAT))
					{
						return (qmlGetFloat (&element->value1) != qmlGetFloat (&element->value2));
					}
					else if (i & DT_STRING)
					{
						return (strcmp (qmlGetString(&element->value1), qmlGetString(&element->value2)));
					}
					else
					{
						return (0);
					}
				break;
				case	qOpGt:
					if (i & (DT_BOOL|DT_BYTE|DT_ANGLE|DT_INT))
					{
						return (qmlGetInt (&element->value1) > qmlGetInt (&element->value2));
					}
					else if (i & (DT_PERCENTUAL|DT_FLOAT))
					{
						return (qmlGetFloat (&element->value1) > qmlGetFloat (&element->value2));
					}
					else
					{
						return (0);
					}
				break;
				case	qOpLt:
					if (i & (DT_BOOL|DT_BYTE|DT_ANGLE|DT_INT))
					{
						return (qmlGetInt (&element->value1) < qmlGetInt (&element->value2));
					}
					else if (i & (DT_PERCENTUAL|DT_FLOAT))
					{
						return (qmlGetFloat (&element->value1) < qmlGetFloat (&element->value2));
					}
					else
					{
						return (0);
					}
				break;
				case	qOpGtEq:
					if (i & (DT_BOOL|DT_BYTE|DT_ANGLE|DT_INT))
					{
						return (qmlGetInt (&element->value1) >= qmlGetInt (&element->value2));
					}
					else if (i & (DT_PERCENTUAL|DT_FLOAT))
					{
						return (qmlGetFloat (&element->value1) >= qmlGetFloat (&element->value2));
					}
					else
					{
						return (0);
					}
				break;
				case	qOpLtEq:
					if (i & (DT_BOOL|DT_BYTE|DT_ANGLE|DT_INT))
					{
						return (qmlGetInt (&element->value1) <= qmlGetInt (&element->value2));
					}
					else if (i & (DT_PERCENTUAL|DT_FLOAT))
					{
						return (qmlGetFloat (&element->value1) <= qmlGetFloat (&element->value2));
					}
					else
					{
						return (0);
					}
				break;
			}
		}
		else
		{
			return (1);
		}
	}

	return (1);
}

void	qmlPrecache (qml_t *qml)
{
	int		i = 0;
	int		j = (int) qaSrc;

	if (qml)
	{
		while ((i != -1) && (i < qml->numElements))
		{
			if (qmlEvaluate (&qml->elements[i]))
			{
				switch (qml->elements[i].tag)
				{
					case	qtPic:
						// Draw_PicFromWad (qml->element[i].pairs[j].value.s);
					break;
					case	qtSpr:
						// TODO
					case	qtMdl:
						// TODO
					case	qtBsp:
						// TODO
					case	qtSnd:
						// TODO
					break;
				}			
				i++;
			}
			else
			{
				i = qml->elements[i].jump;
			}
		}
	}
}

void	qmlRender (qml_t *qml)
{
	int		i = 0;

	if (qml)
	{
		while ((i != -1) && (i < qml->numElements))
		{
			if (qmlEvaluate (&qml->elements[i]))
			{
				switch (qml->elements[i].tag)
				{
					case	qtText:
						qmlDrawText (qml->elements[i].pairs);
					break;
					case	qtPic:
						qmlDrawPic (qml->elements[i].pairs);
					break;
					case	qtSpr:
						qmlDrawSpr (qml->elements[i].pairs);
					break;
					case	qtMdl:
						qmlDrawMdl (qml->elements[i].pairs);
					break;
					case	qtBsp:
						qmlDrawBsp (qml->elements[i].pairs);
					break;
					case	qtBar:
						qmlDrawBar (qml->elements[i].pairs);
					break;
					case	qtSnd:
						qmlPlaySound (qml->elements[i].pairs);
					break;
				}			
				i++;
			}
			else
			{
				i = qml->elements[i].jump;
			}
		}
	}
}