/**
 * qml_test.c
 **/

#include <stdlib.h>
#include <stdio.h>

#include "qml.h"

#pragma	warning (disable:4996)

void	printValue (qmlValue_t *value)
{
	if (value)
	{
		if (value->type & DT_VAR)
		{
			printf ("var ${%i[%i]}", value->var, value->index);
		}
		else if (value->type & (DT_BOOL|DT_BYTE|DT_ANGLE|DT_INT))
		{
			printf ("int %i", value->i);
		}
		else if (value->type & (DT_PERCENTUAL|DT_FLOAT))
		{
			printf ("float %6.2f", value->f);
		}
		else if (value->type & DT_STRING)
		{
			printf ("string \"%s\"", value->s);
		}
	}
	else
	{
		printf ("<null>");
	}
}

void	printPair (qmlPair_t *pair)
{
	if (pair)
	{
		printf ("%i=", (int)pair->attr);
		printValue (&pair->value);
	}
	else
	{
		printf ("<null>");
	}
}

void	printQml (qml_t *qml)
{
	int		i, j;

	if (qml)
	{
		printf ("#elements: %i\n", qml->numElements);
		for (i = 0; i < qml->numElements; i++)
		{
			if (qml->elements[i].op != qOpNone)
			{
				printf ("\t#%i if ", i);
				printValue (&qml->elements[i].value1);
				printf (" op=%i ", qml->elements[i].op);
				printValue (&qml->elements[i].value2);
				printf (" (jump=%i)\n", qml->elements[i].jump);
			}
			else if (qml->elements[i].tag != qtNone)
			{
				printf ("\t#%i tag=%i\n", i, qml->elements[i].tag);
				for (j = 0; j < QMLMAX_ATTR; j++)
				{
					if (qml->elements[i].pairs[j].attr != qaNone)
					{
						printf ("\t\t#%i ", j);
						printPair (&qml->elements[i].pairs[j]);
						printf ("\n");
					}
				}
			}
		}
	}
	else
	{
		printf ("<null>");
	}
}

char	*loadQmlFile (char *filename)
{
	FILE	*fin;
	char	*result = NULL;
	int		i;

	if ((fin = fopen (filename, "rb")) != NULL)
	{
		fseek (fin, 0, SEEK_SET);
		fseek (fin, 0, SEEK_END);
		i = ftell (fin);
		fseek (fin, 0, SEEK_SET);
		if ((result = malloc (i)) != NULL)
		{
			fread (result, 1, i, fin);
		}

		fclose (fin);
	}

	return (result);
}

int		main (int argc, char *argv[])
{
	char	*buf = NULL;
	qml_t	*qml;

	/*if (argc == 2)
	{
		buf = loadQmlFile (argv[1]);
		qml = qmlLoad (buf);
		printQml (qml);
	}*/

	buf = loadQmlFile ("C:\\PESSOAL\\code\\qml\\example1.qml");
	qml = qmlLoad (buf);
	printQml (qml);

	return (0);
}