import math

normals = [
    (-0.525731, 0.000000, 0.850651),
    (-0.442863, 0.238856, 0.864188),
    (-0.295242, 0.000000, 0.955423),
    (-0.309017, 0.500000, 0.809017),
    (-0.162460, 0.262866, 0.951056),
    ( 0.000000, 0.000000, 1.000000),
    ( 0.000000, 0.850651, 0.525731),
    (-0.147621, 0.716567, 0.681718),
    ( 0.147621, 0.716567, 0.681718),
    ( 0.000000, 0.525731, 0.850651),
    ( 0.309017, 0.500000, 0.809017),
    ( 0.525731, 0.000000, 0.850651),
    ( 0.295242, 0.000000, 0.955423),
    ( 0.442863, 0.238856, 0.864188),
    ( 0.162460, 0.262866, 0.951056),
    (-0.681718, 0.147621, 0.716567),
    (-0.809017, 0.309017, 0.500000),
    (-0.587785, 0.425325, 0.688191),
    (-0.850651, 0.525731, 0.000000),
    (-0.864188, 0.442863, 0.238856),
    (-0.716567, 0.681718, 0.147621),
    (-0.688191, 0.587785, 0.425325),
    (-0.500000, 0.809017, 0.309017),
    (-0.238856, 0.864188, 0.442863),
    (-0.425325, 0.688191, 0.587785),
    (-0.716567, 0.681718, -0.147621),
    (-0.500000, 0.809017, -0.309017),
    (-0.525731, 0.850651, 0.000000),
    ( 0.000000, 0.850651, -0.525731),
    (-0.238856, 0.864188, -0.442863),
    ( 0.000000, 0.955423, -0.295242),
    (-0.262866, 0.951056, -0.162460),
    ( 0.000000, 1.000000, 0.000000),
    ( 0.000000, 0.955423, 0.295242),
    (-0.262866, 0.951056, 0.162460),
    ( 0.238856, 0.864188, 0.442863),
    ( 0.262866, 0.951056, 0.162460),
    ( 0.500000, 0.809017, 0.309017),
    ( 0.238856, 0.864188, -0.442863),
    ( 0.262866, 0.951056, -0.162460),
    ( 0.500000, 0.809017, -0.309017),
    ( 0.850651, 0.525731, 0.000000),
    ( 0.716567, 0.681718, 0.147621),
    ( 0.716567, 0.681718, -0.147621),
    ( 0.525731, 0.850651, 0.000000),
    ( 0.425325, 0.688191, 0.587785),
    ( 0.864188, 0.442863, 0.238856),
    ( 0.688191, 0.587785, 0.425325),
    ( 0.809017, 0.309017, 0.500000),
    ( 0.681718, 0.147621, 0.716567),
    ( 0.587785, 0.425325, 0.688191),
    ( 0.955423, 0.295242, 0.000000),
    ( 1.000000, 0.000000, 0.000000),
    ( 0.951056, 0.162460, 0.262866),
    ( 0.850651, -0.525731, 0.000000),
    ( 0.955423, -0.295242, 0.000000),
    ( 0.864188, -0.442863, 0.238856),
    ( 0.951056, -0.162460, 0.262866),
    ( 0.809017, -0.309017, 0.500000),
    ( 0.681718, -0.147621, 0.716567),
    ( 0.850651, 0.000000, 0.525731),
    ( 0.864188, 0.442863, -0.238856),
    ( 0.809017, 0.309017, -0.500000),
    ( 0.951056, 0.162460, -0.262866),
    ( 0.525731, 0.000000, -0.850651),
    ( 0.681718, 0.147621, -0.716567),
    ( 0.681718, -0.147621, -0.716567),
    ( 0.850651, 0.000000, -0.525731),
    ( 0.809017, -0.309017, -0.500000),
    ( 0.864188, -0.442863, -0.238856),
    ( 0.951056, -0.162460, -0.262866),
    ( 0.147621, 0.716567, -0.681718),
    ( 0.309017, 0.500000, -0.809017),
    ( 0.425325, 0.688191, -0.587785),
    ( 0.442863, 0.238856, -0.864188),
    ( 0.587785, 0.425325, -0.688191),
    ( 0.688191, 0.587785, -0.425325),
    (-0.147621, 0.716567, -0.681718),
    (-0.309017, 0.500000, -0.809017),
    ( 0.000000, 0.525731, -0.850651),
    (-0.525731, 0.000000, -0.850651),
    (-0.442863, 0.238856, -0.864188),
    (-0.295242, 0.000000, -0.955423),
    (-0.162460, 0.262866, -0.951056),
    ( 0.000000, 0.000000, -1.000000),
    ( 0.295242, 0.000000, -0.955423),
    ( 0.162460, 0.262866, -0.951056),
    (-0.442863, -0.238856, -0.864188),
    (-0.309017, -0.500000, -0.809017),
    (-0.162460, -0.262866, -0.951056),
    ( 0.000000, -0.850651, -0.525731),
    (-0.147621, -0.716567, -0.681718),
    ( 0.147621, -0.716567, -0.681718),
    ( 0.000000, -0.525731, -0.850651),
    ( 0.309017, -0.500000, -0.809017),
    ( 0.442863, -0.238856, -0.864188),
    ( 0.162460, -0.262866, -0.951056),
    ( 0.238856, -0.864188, -0.442863),
    ( 0.500000, -0.809017, -0.309017),
    ( 0.425325, -0.688191, -0.587785),
    ( 0.716567, -0.681718, -0.147621),
    ( 0.688191, -0.587785, -0.425325),
    ( 0.587785, -0.425325, -0.688191),
    ( 0.000000, -0.955423, -0.295242),
    ( 0.000000, -1.000000, 0.000000),
    ( 0.262866, -0.951056, -0.162460),
    ( 0.000000, -0.850651, 0.525731),
    ( 0.000000, -0.955423, 0.295242),
    ( 0.238856, -0.864188, 0.442863),
    ( 0.262866, -0.951056, 0.162460),
    ( 0.500000, -0.809017, 0.309017),
    ( 0.716567, -0.681718, 0.147621),
    ( 0.525731, -0.850651, 0.000000),
    (-0.238856, -0.864188, -0.442863),
    (-0.500000, -0.809017, -0.309017),
    (-0.262866, -0.951056, -0.162460),
    (-0.850651, -0.525731, 0.000000),
    (-0.716567, -0.681718, -0.147621),
    (-0.716567, -0.681718, 0.147621),
    (-0.525731, -0.850651, 0.000000),
    (-0.500000, -0.809017, 0.309017),
    (-0.238856, -0.864188, 0.442863),
    (-0.262866, -0.951056, 0.162460),
    (-0.864188, -0.442863, 0.238856),
    (-0.809017, -0.309017, 0.500000),
    (-0.688191, -0.587785, 0.425325),
    (-0.681718, -0.147621, 0.716567),
    (-0.442863, -0.238856, 0.864188),
    (-0.587785, -0.425325, 0.688191),
    (-0.309017, -0.500000, 0.809017),
    (-0.147621, -0.716567, 0.681718),
    (-0.425325, -0.688191, 0.587785),
    (-0.162460, -0.262866, 0.951056),
    ( 0.442863, -0.238856, 0.864188),
    ( 0.162460, -0.262866, 0.951056),
    ( 0.309017, -0.500000, 0.809017),
    ( 0.147621, -0.716567, 0.681718),
    ( 0.000000, -0.525731, 0.850651),
    ( 0.425325, -0.688191, 0.587785),
    ( 0.587785, -0.425325, 0.688191),
    ( 0.688191, -0.587785, 0.425325),
    (-0.955423, 0.295242, 0.000000),
    (-0.951056, 0.162460, 0.262866),
    (-1.000000, 0.000000, 0.000000),
    (-0.850651, 0.000000, 0.525731),
    (-0.955423, -0.295242, 0.000000),
    (-0.951056, -0.162460, 0.262866),
    (-0.864188, 0.442863, -0.238856),
    (-0.951056, 0.162460, -0.262866),
    (-0.809017, 0.309017, -0.500000),
    (-0.864188, -0.442863, -0.238856),
    (-0.951056, -0.162460, -0.262866),
    (-0.809017, -0.309017, -0.500000),
    (-0.681718, 0.147621, -0.716567),
    (-0.681718, -0.147621, -0.716567),
    (-0.850651, 0.000000, -0.525731),
    (-0.688191, 0.587785, -0.425325),
    (-0.587785, 0.425325, -0.688191),
    (-0.425325, 0.688191, -0.587785),
    (-0.425325, -0.688191, -0.587785),
    (-0.587785, -0.425325, -0.688191),
    (-0.688191, -0.587785, -0.425325)
]

# We cut the list down into 8 "quadrants". The intent is that for all possible
# vectors in each quadrant, the best normal to approximate it belongs to that
# quadrant's list. For vectors near the edge of a quadrant the best
# approximation may lie in an adjacent quadrant, so the lists are generous and
# overlap to some extent.
# Our technique here would not be correct for different tables of normals, it
# has been tuned to not cause errors in this particular data set.

quadrants = dict()

def dot_product(x, y):
    return sum(a * b for a, b in zip(x, y))

# _DP_THRESHOLD gives a 120 degree cone centred on each quadrant
# Higher thresholds were found experimentally to exclude valid candidates from
# the quadrant lists.
_DP_THRESHOLD = 0.5 * math.sqrt(3)

for s_x in (1, -1):
    for s_y in (1, -1):
        for s_z in (1, -1):
            target = (s_x, s_y, s_z)
            quadrants[target] = []
            for i, normal in enumerate(normals):
                if dot_product(target, normal) > _DP_THRESHOLD:
                    quadrants[target].append(i)