from qmdl.md3 import Md3
from qmdl.helper import Helper
from qmdl.mdl import Mdl
from math import floor

input_md3 = Md3()
with open("e:\python33/fbx/example/arch.md3", "rb") as file:
    input_md3.read(file)

output = Helper()

# find the min and max over all frames and surfaces
mins = tuple(min(z) * Md3.MODEL_SCALE for z in
             zip(*(v.position for s in input_md3.surfaces
                   for v in s.vertices)))
maxs = tuple(max(z) * Md3.MODEL_SCALE for z in
             zip(*(v.position for s in input_md3.surfaces
                   for v in s.vertices)))

output.mdl.scale = tuple(((mx - mn) / 255 for mx, mn in zip(maxs, mins)))
output.mdl.origin = mins
output.mdl.eyeposition = (0, 0, mins[2])

output.append_skin("e:\python33/fbx/example/skin.bmp")

for s in input_md3.surfaces:
    for t in s.texcoords:
        q1_vert = Mdl.Vertex()
        q1_vert.u = floor(t.u * output.mdl.skinwidth)
        q1_vert.v = floor(t.v * output.mdl.skinheight)
        output.mdl.vertices.append(q1_vert)

tri_index_counter = 0
for s in input_md3.surfaces:
    for tri in s.triangles:
        q1_tri = Mdl.Triangle()
        q1_tri.vertices = tuple(v + tri_index_counter for v in tri.vertices)
        output.mdl.triangles.append(q1_tri)
    tri_index_counter += len(s.triangles)


def md3_to_mdl_coord(md3_coord):
    abs_coord = (x * Md3.MODEL_SCALE for x in md3_coord)
    int_coord = (floor(0.5 + ((x - org) / scale)) for x, org, scale in
                 zip(abs_coord, output.mdl.origin, output.mdl.scale))
    return tuple(int_coord)

for i, frame in enumerate(input_md3.frames):
    q1_frame = Mdl.Frame()
    q1_frame.name = frame.name[0:15]
    running_min = (255, 255, 255)
    running_max = (0, 0, 0)
    for s in input_md3.surfaces:
        for v in s.get_frame_vertices(i):
            c = Mdl.Coord()
            c.encode(v.decode())
            c.position = md3_to_mdl_coord(v.position)
            running_min = (min(x, y) for x, y in zip(c.position, running_min))
            running_max = (max(x, y) for x, y in zip(c.position, running_max))
            q1_frame.vertices.append(c)
    q1_frame.bbox_min = Mdl.Coord()
    q1_frame.bbox_min.position = tuple(running_min)
    q1_frame.bbox_max = Mdl.Coord()
    q1_frame.bbox_max.position = tuple(running_max)
    output.mdl.frames.append(q1_frame)

output.save("e:\python33/fbx/example/arch.mdl")